/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.connmgr;

import com.ibm.hwmca.base.managed.BaseTower;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.connmgr.Authenticator;
import com.ibm.hwmca.fw.connmgr.ConnectionConstants;
import com.ibm.hwmca.fw.connmgr.ConnectionGroup;
import com.ibm.hwmca.fw.connmgr.ConnectionHandlerThread;
import com.ibm.hwmca.fw.connmgr.ConnectionServer;
import com.ibm.hwmca.fw.connmgr.DisabledUseridException;
import com.ibm.hwmca.fw.connmgr.InvalidPasswordException;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.logon.LogonValidation;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;

public class ConnectionManager
implements ConnectionConstants {
    public static final String THIS_CLASS = "ConnectionManager";
    private static ConnectionManager SINGLETON;
    ConnectionServer _HMCConnectionServer;
    ConnectionServer _UserConnectionServer;

    public static void logException(Throwable throwable) {
        ConnectionManager.logException(throwable, (short)2096);
    }

    public static void logException(Throwable throwable, short errorId) {
        Trace.trace("HSSLCONF", "--> ConnectionManager.logException");
        new FrameworkLog(ConnectionConstants.LOGINFO, errorId, throwable).log();
        Trace.trace("HSSLCONF", "<-- ConnectionManager.logException");
    }

    public static ConnectionManager getManager() {
        return SINGLETON;
    }

    public static void main(String[] args) throws Exception {
        ConnectionManager mgr = new ConnectionManager();
        mgr.start();
    }

    public static void closeGroup(ConnectionGroup group) {
        if (!group._isClosed) {
            ConnectionHandlerThread.closeHandler(group.getID());
            group._isClosed = true;
        }
    }

    public ConnectionManager() throws IOException, SocketException, HException {
        if (SINGLETON != null) {
            throw new HException("Only one instance of ConnectionManager is allowed.");
        }
        Authenticator.GateKeeper gateKeeper = new Authenticator.GateKeeper(){
            public static final String THIS_CLASS = "User2HMCGatekeeper";

            public byte[] getPassword(String userid) {
                Trace.trace("HSSLCONF", "--> User2HMCGatekeeper.getPassword:  for " + userid);
                byte[] password = null;
                if (userid != null) {
                    try {
                        password = userid.equals("logonuser") ? ConnectionConstants.LOGON_PASSWORD : LogonValidation.GATE_KEEPER.lookupPassword(userid);
                    }
                    catch (DisabledUseridException e) {
                        Trace.trace("HSSLCONF", "User2HMCGatekeeper.getPassword:  userid " + userid + " is disabled.");
                        password = e.getUser().getPassword();
                    }
                    catch (InvalidPasswordException e) {
                        Trace.trace("HSSLCOND", "User2HMCGatekeeper.getPassword:  userid " + userid + " was not found.");
                    }
                }
                Trace.trace("HSSLCONF", "<-- User2HMCGatekeeper.getPassword:  found non-null password is " + (password != null));
                return password;
            }
        };
        this._UserConnectionServer = new ConnectionServer("User Connection Server", 9940, gateKeeper);
        gateKeeper = new Authenticator.GateKeeper(){
            public static final String THIS_CLASS = "HMC2HMCGatekeeper";

            public byte[] getPassword(String userid) throws HException {
                Trace.trace("HSSLCONF", "--> HMC2HMCGatekeeper.getPassword:  for " + userid);
                byte[] password = null;
                try {
                    String domainName = BaseTower.getBaseTower().getDomainName();
                    if (domainName.equals(userid)) {
                        password = BaseTower.getBaseTower().getDomainPassword();
                    } else {
                        Trace.trace("HSSLCONF", "<-- HMC2HMCGatekeeper.getPassword:  userid (really domain mame) mismatch");
                    }
                }
                catch (Exception e) {
                    Trace.trace("HSSLCOND", "HMC2HMCGatekeeper.getPassword:  ", e);
                }
                Trace.trace("HSSLCONF", "<-- HMC2HMCGatekeeper.getPassword:  found non-null password is " + (password != null));
                return password;
            }
        };
        this._HMCConnectionServer = new ConnectionServer("HMC Connection Server", 9920, gateKeeper);
        SINGLETON = this;
    }

    public void start() {
        Trace.trace("HSSLCONT", "-> ConnectionManager.java.start()");
        this._HMCConnectionServer.start();
        this._UserConnectionServer.start();
        Trace.trace("HSSLCONT", "<- ConnectionManager.java.start()");
    }

    public void stop() throws IOException {
        Trace.trace("HSSLCONT", "-> ConnectionManager.java.stop()");
        this._HMCConnectionServer.stopRunning();
        this._UserConnectionServer.stopRunning();
        Trace.trace("HSSLCONT", "<- ConnectionManager.java.stop()");
    }

    public ConnectionServer getUserConnectionServer() {
        return this._UserConnectionServer;
    }

    public ConnectionServer getHMCConnectionServer() {
        return this._HMCConnectionServer;
    }

    public InetAddress getManagerAddress() {
        return this._UserConnectionServer.getInetAddress();
    }

    public static final class Init
    implements Runnable {
        private static ConnectionManager manager = null;

        public void run() {
            try {
                manager = new ConnectionManager();
                manager.start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

